"""Low rank approximation based on the SVD."""

import numpy as np
from sklearn.utils.extmath import randomized_svd

def svd(matrix, rank, lib='sklearn'):
  if lib == 'sklearn':
    u, s, vh = randomized_svd(matrix, n_components=rank)
    return u * s, vh
  elif lib == 'np':
    u, s, vh = np.linalg.svd(matrix, full_matrices=False)
    u, s, vh = u[:, :rank], s[:rank], vh[:rank, :]
    return u * s, vh
  else:
    raise ValueError(f'Invalid lib: {lib}')
